from Crypto.Cipher import AES
from Crypto.Random import get_random_bytes
from Crypto.Protocol.KDF import PBKDF2
from base64 import b64encode, b64decode

# Generate a secure random key
# Store this securely and use it for both encryption and decryption
password = "J1ll@p@tt1R@m@$@mY"
salt = get_random_bytes(16)
key = PBKDF2(password, salt, dkLen=32)

def encrypt_api_key(api_key):
    cipher = AES.new(key, AES.MODE_GCM)
    ciphertext, tag = cipher.encrypt_and_digest(api_key.encode())
    return b64encode(cipher.nonce + tag + ciphertext).decode()

def decrypt_api_key(encrypted_api_key):
    data = b64decode(encrypted_api_key)
    nonce, tag, ciphertext = data[:16], data[16:32], data[32:]
    cipher = AES.new(key, AES.MODE_GCM, nonce=nonce)
    return cipher.decrypt_and_verify(ciphertext, tag).decode()

# Example usage
encrypted_api_key = encrypt_api_key('SattiRanga1243434344543653654745wyrgfgery5w4y64565654w5476546')
print("Encrypted:", encrypted_api_key)

decrypted_api_key = decrypt_api_key(encrypted_api_key)
print("Decrypted:", decrypted_api_key)
